/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.io.UnsupportedEncodingException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.w3c.dom.Node;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpValue;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.IDBGpModelConstants;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.SimpleByteArrayValue;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.SimpleIntValue;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.SimpleVariable;

public class DBGpStringValue
extends DBGpValue {
    private boolean complete = false;
    private int requiredBytes;
    private IVariable[] stringInfo = null;

    public DBGpStringValue(DBGpVariable owningVariable, Node property, int strByteLen) {
        super(owningVariable);
        int actualLength;
        this.setModifiable(true);
        this.simpleParseNode(property);
        if (this.getValueBytes() == null) {
            String XMLEncoding = property.getOwnerDocument().getInputEncoding();
            if (XMLEncoding == null) {
                XMLEncoding = ((DBGpTarget)this.getDebugTarget()).getBinaryEncoding();
            }
            try {
                this.setValueBytes(this.getValueString().getBytes(XMLEncoding));
            }
            catch (UnsupportedEncodingException uee) {
                DBGpLogger.logException("unexpected encoding problem", (Object)this, uee);
                try {
                    this.setValueBytes(this.getValueString().getBytes());
                }
                catch (DebugException e) {
                    DBGpLogger.logException("unexpected exception", (Object)this, e);
                    this.setValueBytes(new byte[0]);
                }
            }
            catch (DebugException e) {
                DBGpLogger.logException("unexpected exception", (Object)this, e);
                this.setValueBytes(new byte[0]);
            }
        }
        this.complete = (actualLength = this.getValueBytes().length) >= strByteLen;
        this.requiredBytes = strByteLen;
    }

    @Override
    public String getReferenceTypeName() throws DebugException {
        return "string";
    }

    @Override
    void genValueString(String data) {
        this.stringInfo = null;
        if (data != null && data.trim().length() > 0) {
            this.setValueString(data);
        } else {
            this.setValueString("");
            this.setValueBytes(new byte[0]);
        }
    }

    @Override
    public void setValue(String expression) throws DebugException {
        byte[] newBytes;
        this.stringInfo = null;
        if (expression != null) {
            this.setValueString(expression.trim());
        } else {
            this.setValueString(IDBGpModelConstants.INVALID_VAR_CONTENT);
        }
        try {
            newBytes = expression.getBytes(((DBGpTarget)this.getDebugTarget()).getBinaryEncoding());
        }
        catch (UnsupportedEncodingException e) {
            DBGpLogger.logException("unexpected encoding problem", (Object)this, e);
            newBytes = expression.getBytes();
        }
        this.setValueBytes(newBytes);
        this.requiredBytes = newBytes.length;
    }

    @Override
    boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getRequiredBytes() {
        return this.requiredBytes;
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        if (this.stringInfo == null) {
            int arrayLength = this.getValueBytes().length;
            this.stringInfo = SimpleByteArrayValue.createVariables(this.getValueBytes(), 0, arrayLength, 1, this.getDebugTarget());
            SimpleIntValue iv = new SimpleIntValue(arrayLength, this.getRequiredBytes(), this.getDebugTarget());
            this.stringInfo[0] = new SimpleVariable(PHPDebugCoreMessages.XDebug_DBGpStringValue_0, iv, this.getDebugTarget());
        }
        return this.stringInfo;
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return true;
    }
}

